#!/usr/local/bin/perl

sub print_structure {
	
	my($this_table, $for_delete, $for_add, $for_new, $for_mod, $for_view)=@_;
	my($action)= $this_action."_final";
	my($del_col, $title, $num_rows, $primKey);

	$title = "Add New Fields" if $for_add;
	$title = "Delete Fields" if $for_delete;
	$title = "Create New Table" if $for_new;
	$title = "Modify Fields" if $for_mod;
	$title = "View Table Info" if $for_view;

	$table = "New Table" if $for_new;

	if ($for_new) {
		
		#if we are creating a new table, the "table" field must be a visible text box 
		#so that the user can enter a table name
		$table_name_field = "Please enter the new table name: <INPUT TYPE=\"TEXT\" NAME=\"table\" VALUE=\"\"><br>";
		$primKey = "<td><b>&nbsp;Primary Key &nbsp;</b></td>";

	} else {
		
		#if not for new table, a table name must be given, and it must be a table that exists in the database
		&print_error("Please select a table to modify.") unless $table;
		&print_error("Table selected doesn\'t exist in this database!") unless &table_exists($table);
		
		#if we are modifing table, the "table" field must be a hidden
		$table_name_field = "<INPUT TYPE=\"HIDDEN\" NAME=\"table\" VALUE=\"$table\">";
		
	} 

	$del_col = "<td><b>&nbsp;Check To Delete Field(s)&nbsp;</b></td>" if $for_delete;
	
	if (($for_delete) or ($for_add) or ($for_mod)) {
		$sth = $dbh->Query(&SQLSelect($table)) or &print_error("SELECT Command Failed!");
		$num_rows = $sth->numrows;
		$num_rows = "There are $num_rows Rows of data in this table.<br>";
		
	} else {
		$num_rows = "";
	}

	print &html("$title");
	print "
		$form_method
		<INPUT TYPE=\"HIDDEN\" NAME=\"action\" VALUE=\"$action\">
		$table_name_field
		$num_rows
		Table Structure:<br>

		<TABLE border = 1>\n
			<tr bgcolor=\"#c0e0a0\">
				<td width=10>&nbsp</td>
				<td><b>&nbsp;Field Name&nbsp;</b></td>
				$primKey
				<td><b>&nbsp;Type&nbsp;</b></td>
				<td><b>&nbsp;Nulls&nbsp;</b></td>
				<td><b>&nbsp;Lenght**&nbsp;</b></td>
				$del_col
			</tr>
	"; #Eof Printing Here
	
	print "<tr bgcolor=\"#a1c2f0\"><td colspan=5>Existing Fields:</td></tr>" if $for_add;

	if ($for_new) {
		
		#let them create a table of up to new_table_fields_count fields
		&new_fields_boxes($new_table_fields_count,1);

	} else {

		$sth = $dbh->ListFields($this_table);
		for (0..$sth->numfields-1) {

			if ($for_delete) {
				$del_col = $delete_box; 
				$del_col =~ s/#/$_/eg;
				$del_col = "</td><td> &nbsp;".$del_col; 
			
			#} elsif ($for_delete) {

			} else {
				$del_col = "";
			}

			print 	"<tr><td>". ($_+1)."</td><td> &nbsp;".
						&primary($sth->is_pri_key->[$_]).$sth->name->[$_]."</td><td> &nbsp;".
						&sqltype($sth->type->[$_])."</td><td> &nbsp;".
						&nulls($sth->is_not_null->[$_])."</td><td> &nbsp;".
						$sth->length->[$_].
					"$del_col </td></tr>\n";
		}
		if ($for_add) {
			print "<tr bgcolor=\"#a1c2f0\"><td colspan=5>Add New Fields Below:</td></tr>";
			&new_fields_boxes($new_fields_count);
		}
	}


	print "</table><br>\n";
	
	if ($for_add) {
		print "<center><INPUT TYPE=\"submit\" NAME=\"submit\" VALUE=\"Add Fields\">";
		print "<INPUT TYPE=\"reset\" NAME=\"reset\" VALUE=\"Clear New Fields\"></center><br>";
		print "</form>";
		print "<FONT SIZE=2><b>*</b>Primary Key Field (if any)</font><br>";
		print "<FONT SIZE=2><b>**</b>Relevant only for fields of type Character (CHAR)</font>";
		print "<br><br>Click here for <a href = \"/msql_keeper/cgi/mk_main.cgi?action=naming_conventions\">miniSQL Field/Table Naming rules</a>.";

	} elsif ($for_delete) {
		print "<center><INPUT TYPE=\"submit\" NAME=\"submit\" VALUE=\"Delete Checked Fields\">";
		print "<INPUT TYPE=\"reset\" NAME=\"reset\" VALUE=\"Clear Checked Fields\"></center><br>";
		print "</form>";
		print "<FONT SIZE=2><b>*</b>Primary Key Field (if any)</font><br>";
		print "<FONT SIZE=2><b>**</b>Relevant only for fields of type Character (CHAR)</font>";

	} elsif ($for_new) {
		print "<center><INPUT TYPE=\"submit\" NAME=\"submit\" VALUE=\"Create Table\">";
		print "<INPUT TYPE=\"reset\" NAME=\"reset\" VALUE=\"Clear Fields\"></center><br>";
		print "</form>";
		print "<FONT SIZE=2><b>**</b>Relevant only for fields of type Character (CHAR)</font>";
		print "<br><br>If you need more than 10 fields, create the table and use the Add Fields feature.<br>";
		print "<br><br>Click here for <a href = \"/msql_keeper/cgi/mk_main.cgi?action=naming_conventions\">miniSQL Field/Table Naming rules</a>.";

	} elsif ($for_mod) {
	

	} elsif ($for_view) {
		print "<FONT SIZE=2><b>*</b>Primary Key Field (if any)</font><br>";
		print "<FONT SIZE=2><b>**</b>Relevant only for fields of type Character (CHAR)</font>";
		print "<br><br><b>-----------------------------------------------------------</b>";
		&show_data;
		
	} else {
    
	}
		
	print &html_bot;
	return 1;
}

sub add_field {

	my($i, $err, $sth_hold_insert, $sql_for_data, $sth_hold, $sql, $sth, $new_fields, $numFields);
	local(@arr);

#***first, loop thru the new fields and validate
	&check_new_fields($new_fields_count);

#OK, now lets do the deed
#***1st, lets select * from $table and hold the data to memory
	$sth_hold = $dbh->Query(&SQLSelect($table)) or &sql_fail(&SQLSelect($table));
	$num_rows = $sth_hold->numrows;

#*** get create table sql for existing fields + new fields
	$sql  = &SQLCreate($table).",";
	$sql .= &SQLCreate_new_fields($new_fields_count);
    $sql = "CREATE TABLE $table \($sql\)\n";
	
#*** drop this table
	&drop_table_final($table);

#*** re-create the table with the new fields
	$sth = $dbh->Query($sql) or &sql_fail($sql);
		
#*** insert the data holded in memory
	$sql = &sql_insert_stmt($table);
	$numFields = &table_field_count($table);
	
	while(@arr = $sth_hold->FetchRow) {
		&insert_from_array(*arr, $sql, $numFields-1);
	}

	#Tell'em about it
	print &html("Add Fields");
	print "$new_fields New Field(s) Added to table <i>$table</i> successfully.<br>";
	print "New fields that allow NULL values were filled with NULLS.<br>";
	print "New field(s) that do NOT allow NULLS, were filled with zeroes if of INT or REAL type.<br>";
	print "New field(s) that do NOT allow NULLS, were filled with zero-length strings ('') if of CHAR type.<br>";
	print "<b>Data in old fields was NOT changed.</b><br>";
	print "There are $num_rows rows of data in the table";
	print qq*<a href = "/msql_keeper/cgi/mk_main.cgi?action=view_info&table=$table">View Table Info</a>*;
	print &html_bot;
	exit;
	
}

sub remove_field {
	
	my($sth, $sql, $sth_hold, $sth_hold_insert);
	local(@arr);

#***Get Create table fields	sql, excluding deleted fields
	$sql = &SQLCreate($table);
		
#***select and hold existing data from fields not marked for deletion into memory
	#the SQLSelect will select everything from the table exept the deleted fields
	$sth_hold = $dbh->Query(&SQLSelect($table)) or &sql_fail(&SQLSelect($table));
	$num_rows = $sth_hold->numrows;
	
#*** drop this table
	&drop_table_final($table);

#*** re-create the table with the new field layout
	$sql = "CREATE TABLE $table \($sql\)\n";
	$sth = $dbh->Query($sql) or &sql_fail($sql);

#***insert old data, kept in $sth_hold
	$sql = &sql_insert_stmt($table);
	$numFields = &table_field_count($table);
	
	while(@arr = $sth_hold->FetchRow) {
		&insert_from_array(*arr, $sql, $numFields-1);
	}

	print &html("Delete Fields");
	print "Fields marked for removal were deleted sucessfully.<br>";
	print "Data in remaining fields was NOT changed.<br>";
	print "Data in deleted fields was LOST.<br>";
	print "There are $num_rows rows of data in the table.<br>";
	print qq*<a href = "/msql_keeper/cgi/mk_main.cgi?action=view_info&table=$table">View Table Info</a>*;
	print &html_bot;
	return 1;

}

sub mod_fields {
	
	my($action)= $this_action."_final";
	my($del_col, $title, $num_rows, $primKey, $sth);
	my($len, $type, $name);
	$title = "Modify Fields";
	
	&print_error("Please select a table to modify.") unless $table;
	#if not for new table, a table name must be given, and it must be a table that exists in the database
	&print_error("Table selected doesn't exist in this database!") unless &table_exists($table);

	#if we are modifing table, the "table" field must be a hidden
	$table_name_field = "<INPUT TYPE=\"HIDDEN\" NAME=\"table\" VALUE=\"$table\">";
		
	$sth = $dbh->Query(&SQLSelect($table)) or &print_error("SELECT Command Failed!");
	$num_rows = $sth->numrows;
	$num_rows = "There are $num_rows Rows of data in this table.<br>";
		
	print &html("$title");
	print "
		$form_method
		<INPUT TYPE=\"HIDDEN\" NAME=\"action\" VALUE=\"$in{'action'}_final\">
		$change_structure_warning
		$table_name_field
		$num_rows
		Table Structure:<br>
		<TABLE border = 1>\n
			<tr bgcolor=\"#c0e0a0\">
				<td width=10>&nbsp</td>
				<td><b>&nbsp;Field Name&nbsp;</b></td>
				<td><b>&nbsp;Type&nbsp;</b></td>
				<td><b>&nbsp;Lenght**&nbsp;</b></td>
			</tr>
	"; #Eof Printing Here
	
	$sth = $dbh->ListFields($table);
	for (0..$sth->numfields-1) {
		$name = $sth->name->[$_];
		$type = &typeSelect($sth->type->[$_]);
		$type =~ s/#/$_/eg;
		$len = $sth->length->[$_];

		print "<tr><td>". ($_+1)."</td><td> &nbsp;";
		print qq*<INPUT TYPE="TEXT" NAME="new_name$_" VALUE="$name" MAXLENGTH="50"><b>*;
		print &primary($sth->is_pri_key->[$_])."</b></td><td> &nbsp;";
		print "$type</td><td> &nbsp;";
		print qq*<INPUT TYPE="TEXT" NAME="length$_" VALUE="$len" MAXLENGTH="20"></td></tr>\n*;
	}

    print "</table><br>\n";
	print "<center><INPUT TYPE=\"submit\" NAME=\"submit\" VALUE=\"Save Changes\">";
	print "<INPUT TYPE=\"reset\" NAME=\"reset\" VALUE=\"Undo Changes\"></center><br>";
	print "</form>";
	print "<FONT SIZE=2><b>*</b>Primary Key Field (if any)</font><br>";
	print "<FONT SIZE=2><b>**</b>Relevant only for fields of type Character (CHAR)</font>";
	print &html_bot;
	return 1;
}

sub mod_fields_final {
	
	local(@arr);
	my ($sql, $sth_hold, $num_rows);
	my $numFields = &table_field_count($table);
	&check_new_fields($numFields);

#***select and hold existing data from fields 
	$sth_hold = $dbh->Query(&SQLSelect($table)) or &print_error("SELECT Command Failed!");
	$num_rows = $sth_hold->numrows;

#***Get the create table sql
	$sql .= &SQLCreate_new_fields($numFields);
    $sql = "CREATE TABLE $table \($sql\)\n";

#***drop this table
	&drop_table_final($table);

#***re-create the table with the new field layout
	my $sth = $dbh->Query($sql) or &sql_fail($sql);

#***insert old data, kept in $sth_hold
	$sql = &sql_insert_stmt($table);
	
	while(@arr = $sth_hold->FetchRow) {
		&insert_from_array(*arr, $sql, $numFields - 1);
	}
    
	print &html;
	print "Structure of table <b><i>$table</b></i> was successfully changed.";
	print qq*<a href = "/msql_keeper/cgi/mk_main.cgi?action=view_info&table=$table">View Table Info</a>*;
	print  &html("",1);
	return 1;

}

1;
